/**********************************************************************
*
* teach uevent.c -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements the 
* main event loop used by the Teach program.
*
**********************************************************************/

#include <types.h>
#include <menu.h>
#include <quickdraw.h>
#include <window.h>
#include "teach.h"

extern WmTaskRec        event;
extern unsigned int     quitFlag;
extern GrafPortPtr      lastWindow;

/**********************************************************************/

void    enableDAItems()
{
    EnableMItem(UndoItem);
    EnableMItem(CloseItem);
    SetMenuFlag(0xFF7F, EditMenuID);
}

/**********************************************************************/

void    enableAppItems()
{
    EnableMItem(SelectAllItem);
    EnableMItem(CloseItem);
    EnableMItem(SaveItem);
    EnableMItem(SaveAsItem);
    EnableMItem(PageSetupItem);
    EnableMItem(PrintItem);
    SetMenuFlag(0xFF7F, SizeMenuID);        /* enable the size menu */
    SetMenuFlag(0xFF7F, StyleMenuID);       /* enable the style menu */
    SetMenuFlag(0xFF7F, FontMenuID);        /* enable the font menu */
    SetMenuFlag(0xFF7F, EditMenuID);        /* enable the edit menu */
}

/**********************************************************************/

void    disableDAItems()
{
    DisableMItem(UndoItem);
}

/**********************************************************************/

void    disableAppItems()
{
    SetMenuFlag(0x0080, EditMenuID);        /* disable the edit menu */
    SetMenuFlag(0x0080, FontMenuID);        /* disable the font menu */
    SetMenuFlag(0x0080, StyleMenuID);       /* disable the style menu */
    SetMenuFlag(0x0080, SizeMenuID);        /* disable the size menu */
    DisableMItem(SaveItem);
    DisableMItem(SaveAsItem);
    DisableMItem(PageSetupItem);
    DisableMItem(PrintItem);
    DisableMItem(SelectAllItem);
}



/*********************************************************************
*
* CheckFrontW
*
* This routine checks the front window to see if any changes need
* to be made to the menu items.
*
* We do this so that the edit items are only active when a desk
* accessory is active.
*
*********************************************************************/
void    checkFrontW()
{
    GrafPortPtr     theWindow;

    theWindow = FrontWindow();

    if (theWindow == lastWindow) return;
        /* If the LastWindow is this window, we are all set. */

    if (!theWindow) {           /* If no front window... */
        disableDAItems();
        disableAppItems();
        DisableMItem(CloseItem);
    }
    else {                      /* Look at what kind of window we have... */
        if (GetSysWFlag(theWindow)) {
            disableAppItems();
            enableDAItems();
        }
        else {
            disableDAItems();
            enableAppItems();
        }
    }

    DrawMenuBar();
    lastWindow = theWindow;
}



/*************************************************************************
*
* MainEvent
*
* This is the main part of the program.  The program cycles in this
* loop until the user choose select.
*
*************************************************************************/
void    mainEvent()
{
    for (;;) {
        checkFrontW();
        switch(TaskMaster(0xFFFF, &event)) {
            case wInGoAway:
                doCloseTop();
                break;
            case wInSpecial:
            case wInMenuBar:
                doMenu();
                break;
        }
        if (quitFlag) break;
    }
}
